{# twig vars #}{##}
{% set termsElem %}<div class="ue_tags_terms">{{putPostTags(item.post_list.id)}}</div>{% endset %}
{% set buttonLinkElem %}<a target="{{open_links_in_new_tab}}" {{item.post_list.dynamic_popup_link_attributes|raw}} class="uc_more_btn {{button_hover_effect}} {{item.post_list.dynamic_popup_link_class}}" title="{{button_title}}">{{button_text|raw}}</a>{% endset %}
{% set metaDateElem %}
<div class="ue-meta-data">
  {% if show_date == "true" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{date_icon_html|raw}}</span> {{text_before_date|raw}} {{item.post_list.date|ucdate(date_format)|raw}}</div>{% endif %}
  {% if show_time == "true" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{time_icon_html|raw}}</span> {{text_before_time|raw}} {{item.post_list.date|ucdate("g:i a")|raw}}</div>{% endif %}
  {% if show_time_ago == "true" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{time_ago_icon_html|raw}}</span> {{text_before_time_ago|raw}} {{item.post_list.date|ucdate("time_ago")|raw}}</div>{% endif %}           
  {% if show_comments == "true" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{comments_icon_html|raw}}</span> {{text_before_comments|raw}}  {% set num_comments = ucfunc("get_num_comments", item.post_list.id) %} {{num_comments}} </div>{% endif %}
  {% if show_author == "true" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{author_icon_html|raw}}</span> {{text_before_author|raw}} {% set author = getPostAuthor(item.post_list.author_id) %} {{author.name}}</div>{% endif %}            
            
  {% if show_custom_meta_one == "true" %}
    {% set custom_field_value = ucfunc("get_post_custom_field", item.post_list.id,custom_meta_name_one) %}
          
    {% if(meta_field_one_convert == "date") %}
      {% set custom_field_value = custom_field_value|ucdate(meta_one_date_dest,meta_one_date_source) %}
    {% endif %}
          
    <div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{custom_meta_icon_one_html|raw}}</span> {{custom_meta_text_before_one|raw}} {{custom_field_value|raw}}</div>
  {% endif %}
            
  {% if show_custom_meta_two == "true" %}
    {% set custom_field_value = ucfunc("get_post_custom_field", item.post_list.id,custom_meta_name_two)%} 
    
    {% if(meta_field_two_convert == "date") %}
      {% set custom_field_value = custom_field_value|ucdate(meta_two_date_dest,meta_two_date_source) %}
    {% endif %}
            	
    <div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{custom_meta_icon_two_html|raw}}</span> {{custom_meta_text_before_two|raw}} {{custom_field_value|raw}}</div>
  {% endif %}
            
  {% if show_custom_meta_three == "true" %}
    {% set custom_field_value = ucfunc("get_post_custom_field", item.post_list.id,custom_meta_name_three) %} 
  
    <div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{custom_meta_icon_three_html|raw}}</span> {{custom_meta_text_before_three|raw}} {{custom_field_value|raw}}</div>
  {% endif %}

    {% if debug_meta_fields == "true" %}
      <div class="ue-debug-meta">
        {{ucfunc("put_post_meta_debug",item.post_list.id)}}
      </div>
    {% endif %}  
</div>{# end ue-meta-data #}{##}
{% endset %}{# end metaDateElem #}{##}
{# end twig vars #}{##}
<div class="uc_post_list_box" data-category="{{item.post_list.category_name|raw}}">
  
  	{% if post_list_show_image == "true" %}
    <div class="uc_post_list_image">
      <a {% if disable_link == "false" %}href="{{item.post_list.link}}" target="{{open_links_in_new_tab}}"{% endif %} title="{{item.post_list.title}}">
         {% if item.post_list.image is empty %}
            <img src="{{uc_assets_url}}/placeholder.jpeg">
        {% else %} 
            <img src="{{item.post_list.image}}" {{item.post_list.image_attributes|raw}}>
        {% endif %}	        
      </a>
    </div>
  	{% endif %}	
  
    <div class="uc_post_list_content">
      <div class="uc_post_list_content_inside">
        
        {% if show_category == "cat" or show_category == "bytax" or show_category == "lastlevel" %}
                
          {% if show_category == "cat" %}
        	{% set arrcats = item.post_list.categories %}
          {% elseif show_category == "lastlevel" %}
        	{% set arrcats =  getPostTerms(item.post_list.id, cat_tax, false,"last_level",cat_maxterms) %}        		
        
          {% else %}
        	{% set arrcats =  getPostTerms(item.post_list.id, cat_tax, false,"",cat_maxterms) %} 
		  {% endif %}
        
          <div class="ue-grid-item-category">
            {% for cat in arrcats %}
              <a {% if disable_link == "false" %}href="{{cat.link}}" target="{{open_links_in_new_tab}}"{% endif %}>{{cat.name|raw}}</a>
            {% endfor %}
          </div>
        
        {% elseif show_category == "main" %}
        
        	<div class="ue-grid-item-category">
              <a {% if disable_link == "false" %}href="{{item.post_list.category_link}}" target="{{open_links_in_new_tab}}"{% endif %}>{{item.post_list.category_name|raw}}</a>
        	</div>
        	
        {% endif %}
        
        {% if (show_tags == "true") and (tags_position == "above_title") %}{{termsElem}}{% endif %}     
        {% if post_list_show_title == "true" %}<{{title_html_tag}} class="uc_post_list_title"><a {% if disable_link == "false" %}target="{{open_links_in_new_tab}}" href="{{item.post_list.link}}"{% endif %} title="{{item.post_list.title}}">{{item.post_list.title|raw}}</a></{{title_html_tag}}>{% endif %}
        {% if (show_tags == "true") and (tags_position == "below_title") %}{{termsElem}}{% endif %}         
        {% if meta_data_position == "before_text" %}{{metaDateElem}}{% endif %}      
        {% if (show_tags == "true") and (tags_position == "above_desc") %}{{termsElem}}{% endif %}       
        {% if show_text == "true" %}<div class="uc_post_content">{{item.post_list.intro_full|truncate(intro_number_of_characters)|raw}}</div>{% endif %}
        {% if meta_data_position == "after_text" %}{{metaDateElem}}{% endif %}
        {% if (show_tags == "true") and (tags_position == "below_desc") %}{{termsElem}}{% endif %}          
        {% if show_link_button == "true" and link_button_location == "content" %}{{buttonLinkElem}}{% endif %}
        
      </div>
    </div>
     
     {% if show_link_button == "true" and link_button_location == "side" %}
       <div class="button-on-side">{{buttonLinkElem}}</div>
     {% endif %}  
  
   {% if make_all_item_link == "true" %}
      <a {% if disable_link == "false" %}target="{{open_links_in_new_tab}}" href="{{item.post_list.link}}"{% endif %} class="ue-post-link-overlay"></a>
   {% endif %}
</div>