/* general styles */
.uc_quote_slider{
  min-height:1px;
}

#{{uc_id}} *{
  box-sizing:border-box;
}

#{{uc_id}} .uc_quote_info .uc_author_avatar {
  width: 100%;
}

#{{uc_id}} .uc_quote_info .uc_author {
  display: inline-flex;
  align-items: {{title_subtitle_align}}; 
  {% if title_subtitle_align == "center" %}
  text-align:center;
  {% endif %}
}

#{{uc_id}} .uc_stars{
  display:flex;
}

#{{uc_id}} .uc_quote_info{
  display:flex;
}

#{{uc_id}} *{
  outline:none;
}

#{{uc_id}} .ue-image{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .uc_quote_info .uc_author_info .uc_company {
    color: {{color}};
}

#{{uc_id}} .ue-image-spacing{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-icon{
  display:inline-flex;
  justify-content:center;
  align-items:center;
}

#{{uc_id}} .ue-icon svg{
  width:1em;
  height:1em;
}

#{{uc_id}} .uc_quote_item,
#{{uc_id}} .ue-flip-item-content{
  transition: all .3s;
}

/* end general styles */

/* carousel type owl */
{% if carousel_type == "owl" %}
  #{{uc_id}} .owl-dots {
    overflow:hidden;
  }

  #{{uc_id}} .owl-dot {
    display:inline-block;
  }

  #{{uc_id}} .owl-nav .owl-prev,
  #{{uc_id}} .owl-nav .owl-next{
      position:absolute;
      display:inline-block;
      text-align:center;
  }

  {% if transition_easing == "false" %}
  	#{{uc_id}} .owl-stage        {
       transition-timing-function: linear!important;
    }
  {% endif %}

  {% if make_3d == "true" %} 
    #{{uc_id}} .ue-item {
        opacity: 0.3;
        transform: scale3d(0.8, 0.8, 1);
        transition: all 0.3s ease-in-out;
    }

    #{{uc_id}} .active.center{
        z-index: 1;
    }

    #{{uc_id}} .active.center .ue-item {
        opacity: 1;
        transform: scale3d(1, 1, 1);
        transition: all 0.3s ease-in-out;
    }
  {% endif %}


{% endif %}
/* end carousel type owl */

/* carosuel type grid */
.team_member_grid{
  position:relative;
  display:grid;
}

.team_member_grid .ue_grid_item{
  position:relative;
  display:flex;
  flex-direction:column;
}
/* end carousel type grid */