#{{uc_id}} 
{ 
  text-align: {{alignment}}; 
  position: relative;
  overflow:hidden;
  display:flex;
  flex-direction:{{layout}};
}


#{{uc_id}} .ue-graphic-element
{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  overflow:hidden;
}

#{{uc_id}} .ue-graphic-element svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-graphic-element img
{
  display:block;
}

#{{uc_id}} .ue-item-image img
{
  width:100%;
  display:block;
}

#{{uc_id}} .uc_container .uc_btn {

    text-align: center;
    display: inline-block;
    text-decoration: none;
    transition: ease-in-out all 0.25s;
}

{% if layout == "row" %}
#{{uc_id}} .uc_tab_nav{
	flex-direction:column;
    flex-grow:0;
    flex-shrink:0;
}  
{% endif %}	


#{{uc_id}} * {
    box-sizing: border-box;
}
#{{uc_id}} .ue-tab-btn
{
  transition: 0.5s;
} 

#{{uc_id}} > ul.tabs{
   margin:0px;
   list-style:none;
   display:flex;
}

{% if scrollable_tabs == "true" %}

  #{{uc_id}} > ul.tabs{
     justify-content:unset;
     flex-wrap: nowrap;
     overflow-x: scroll; 
  }

  #{{uc_id}} > ul.tabs::-webkit-scrollbar{
     display: none;
  }

{% else %}

  #{{uc_id}} > ul.tabs{
      justify-content:{{tab_bar_alignment}};
      flex-wrap: wrap;
  }

{% endif %}

#{{uc_id}} > ul.tabs > li
{
	padding:0px; 
	margin:0px;
    {% if make_tabs_equal == "true" %}
        flex:1;
       text-align:center;
    {% endif %}	

}


	
#{{uc_id}} > ul.tabs > li > a {
	
	display:flex;
	text-decoration:none;
    transition:0.5s;
    flex-wrap: wrap;
    
}

#{{uc_id}} .tab-container {
	clear:both;
	overflow:hidden;
}

#{{uc_id}} .ue_post_image img
{
  display:block;
  width:100%;
  object-fit: cover;
}

#{{uc_id}} .ue_post_link
{
  display:{{button_style}};
  text-decoration:none;
}

#{{uc_id}} .panes{ display:none;}
#{{uc_id}}.r-tabs .r-tabs-tab {
    display: block;
    margin: 0;
    list-style: none;
}

#{{uc_id}}.r-tabs .r-tabs-panel {
    display: none;
}

#{{uc_id}}.r-tabs .r-tabs-accordion-title {
    display: none;
}

#{{uc_id}}.r-tabs .r-tabs-panel.r-tabs-state-active {
    display: flex;
}
#{{uc_id}} .panel-container{
   width:100%;
 }
{% if image_layout == "side" %}
 #{{uc_id}} .ue-item-content-layout
{
  display:flex;
}

 #{{uc_id}} .ue-item-image-wrapper
{
  flex-grow:0;
  flex-shrink:0;
}

 #{{uc_id}} .ue-item-content-wrapper
{
  flex-grow:1;
}
{% endif %}

{% if accordion_breakpoint == "true" %}

@media only screen and (max-width: {{responsive_breakpoint}}px){
  
 #{{uc_id}} > ul.tabs {display:none;}
 #{{uc_id}}.r-tabs .r-tabs-nav { display: none;}

 #{{uc_id}}.r-tabs .r-tabs-accordion-title { display: block;}
 #{{uc_id}} .r-tabs-accordion-title .r-tabs-anchor{ 
      display:flex;
      align-items:center;
      overflow:hidden; 
 }
  
 #{{uc_id}} .uc-tabs-accordion-title{
     flex-grow:1;
 }
  
 #{{uc_id}} .r-tabs-accordion-title .uc-accordion-icon-collapse{
    display:none;    
 }
  
 #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-collapse{
    display:block;
 }
  
 #{{uc_id}} .r-tabs-accordion-title.r-tabs-state-active .uc-accordion-icon-expand{
    display:none;
 }
  
 #{{uc_id}} .ue-item-content-layout{
    display:flex;
    flex-direction:column;
 }

 #{{uc_id}} .ue-item-image-wrapper{
 	width:100%;
 }

 #{{uc_id}} .uc-tabs-accordion-title{
    display:flex;
    align-items:center;
 }

 #{{uc_id}} .panel-container{
   width:100%;
   {% if disable_content_bg_color_accordion == "true" %}
   	 background-color: unset;
   {% endif %}
 } 
  
  #{{uc_id}} .tab-container{
    background-color: {{accordion_content_background_color}};
  }
  
}

{% endif %}