{{ ucfunc("put_docready_start") }}

  var objWidget = jQuery('#{{uc_id}}');

  //carousel type owl
  {% if carousel_type == "owl" %}	
  
    function initCarousel(){

      objWidget.owlCarousel({
              setActiveClassOnMobile:{{active_on_mobile}},
              loop: {{loop}},
              center:{{center}},
              rtl:{{rtl}},
              autoplay:{{autoplay}},
              autoplayHoverPause:{{autoplayhoverpause}},
              navText : ["<i class='{{left_arrow}}'></i>","<i class='{{right_arrow}}'></i>"],
              changeItemOnClick:{{scroll_on_click}},
              rewindNav : false,
              autoplayTimeout:{{autoplay_interval}},
              smartSpeed: {{transition_speed}},  
              dots:{{show_dots}},
              scrollToHead: {{scroll_to_head}},
              scrollToHeadOffset: {{scroll_to_head_offset}},
              paddingType: "{{stage_padding_type}}",
              mouseDrag:{{mouse_drag}},
              touchDrag:{{touch_drag}},
              mousewheelControl: {{enable_mouse_wheel_control}},
              scrollToHead:{{scroll_to_head}},
              scrollToHeadOffset: {{scroll_to_head_offset}},
              responsive: {

                     0 : {
                          items:{{number_of_items_mobile}},
                          slideBy: {{slides_to_scroll_mobile}},
                          nav: {{show_arrows_mobile}},
                          scrollToHeadForceOnMobile: {{scroll_to_head_forced_on_mobile}},  
                          margin:{{margin_between_slides_mobile}},  
                          {% if stage_padding_type != "none" %}
                            stagePadding: {{stagepadding_mobile}},
                          {% endif %}	
                      },
                      768 : {
                          items:{{number_of_items_tablet}},
                          slideBy: {{slides_to_scroll_tablet}},
                          nav: {{show_arrows_tablet}},
                          margin:{{margin_between_slides_tablet}},
                          {% if stage_padding_type != "none" %}
                            stagePadding: {{stagepadding_tablet}},
                          {% endif %}
                      },
                      980 : {
                          items:{{number_of_items}},
                          slideBy: {{slides_to_scroll}},
                          nav: {{show_arrows}},
                          margin:{{margin_between_slides}},
                          {% if stage_padding_type != "none" %}
                            stagePadding: {{stagepadding}},
                          {% endif %} 
                      }  
                  }
        });

    }

    initCarousel();

    objWidget.on("uc_ajax_refreshed",function(){      
          objWidget.trigger('destroy.owl.carousel');      
          initCarousel();      
    });

    {{ucfunc("put_remote_parent_js","objWidget")}}
   
  {% endif %}
  //end carousel type owl
  
  //carousel type marquee
  {% if carousel_type == "marquee" %}
  
    var objMarquee = objWidget.find('.uc_marquee');

    UCTestimonialMarquee(objMarquee);

    objWidget.on("uc_ajax_refreshed",function(){
          UCMarquee(objMarquee);     
     });
   
  {% endif %}
  //end carousel type marquee
  
  //carousel type coverflow
  {% if carousel_type == "coverflow" %}	
  
    function startCoverflow(){

      objWidget.show();

      objWidget.flipster({
              style: '{{style_coverflow}}',

                {% if style_coverflow == "infinite-carousel" %}                  
                 loop: 2,
                 spacing: 0,
                {% else %}  
                 loop: {{loop_coverflow}}, 
                 spacing: {{spacing_coverflow}},                  
                {% endif %}  

              pauseOnHover: {{pauseonhover_coverflow}},

                {% if navigation_coverflow == "false" %}
                  nav: false,
                {% endif %}

                {% if navigation_coverflow == "before" %}
                  nav: 'before',
                {% endif %}

                {% if navigation_coverflow == "after" %}
                  nav: 'after',
                {% endif %}

                {% if autoplay_coverflow == "true" %}
                  autoplay: {{autoplay_timeout_coverflow}},
                {% endif %}                        

              click: {{click_coverflow}},
              keyboard: {{keyboard_coverflow}},
              scrollwheel: {{scrollwheel_coverflow}},
              touch: {{touch_coverflow}},

              {% if start_coverflow is empty %}
              {% else %} 
                  start: {{start_coverflow|raw}}, 
              {% endif %}	

              buttons: {{show_coverflow_nav_arrows}}
      });

    }

    startCoverflow();

    objWidget.on("uc_ajax_refreshed",function(){

      //remove flipster classes from mani container
      objWidget.removeClass("flipster flipster--transform flipster--infinite-carousel flipster--click flipster--active");

      var objButtons = objWidget.find('.flipster__nav');
      var objArrows = objWidget.find('.flipsflipster__button');

      //remove buttons and arrows
      objButtons.remove();
      objArrows.remove();

      //reinit flipster
      startCoverflow();

    });

    var objRemoteOptions = {
          class_items:"ue-coverflow-item",
          class_active:"flipster__item--current",
          selector_item_trigger:".flipster__item__content"
    };

    {{ucfunc("put_remote_parent_js","objWidget","objRemoteOptions")}}  
  
  {% endif %}
  //end carousel type coverflow
  
  //carousel type swipe
  {% if carousel_type == "swipe" %}	
  
    var swipeJs = new ueSwipeJs();
    swipeJs.init("#{{uc_id}} .uc-items-wrapper");  
   
  {% endif %}
  //end carousel type swipe

{{ ucfunc("put_docready_end") }}